<?xml version="1.0" encoding="UTF-8"?>

<%--
 ===================================================================
  Licensed Materials - Property of IBM
 
  WebSphere Commerce
 
  (c) Copyright International Business Machines Corporation.
      2007, 2008
      All Rights Reserved.
 
  US Government Users Restricted Rights - Use, duplication or
  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 ===================================================================
--%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://commerce.ibm.com/foundation" prefix="wcf"%>

<c:choose>
	<c:when test="${empty param.searchText}">	
		<%-- No search criteria is specified --%>
		<objects
			recordSetCompleteIndicator="true"
		 	recordSetReferenceId=""
			recordSetStartNumber=""
			recordSetCount="0"
			recordSetTotal="0">
		</objects>
	</c:when>

	<c:otherwise>
		<wcf:getData type="com.mycompany.commerce.project.facade.datatypes.ProjectType[]"
			var="projects"
			expressionBuilder="findProjectsBasicSearch"
			varShowVerb="showVerb"
			recordSetStartNumber="${param.recordSetStartNumber}"
			recordSetReferenceId="${param.recordSetReferenceId}"
			maxItems="${param.maxItems}">
			<wcf:contextData name="storeId" data="${param.storeId}"/>
			<wcf:param name="name" value="${param.searchText}"/>
		</wcf:getData>

		<jsp:directive.include file="serialize/SerializeRecipes.jspf"/>
	</c:otherwise>
</c:choose>	

